Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      create_queues.sql - Creates queues used for this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates two queues with payload of type MGW_TIBRV_MSG_T:
Rem      MGW_TIBRV_SRC, MGW_TIBRV_DEST.
Rem
Rem    NOTES
Rem      This script assumes that create_users.sql has already been run.
Rem
Rem

connect mgwuser/mgwuser
set serveroutput on

-- create queue tables and queues
begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_tibrv_mc',
                   queue_payload_type => 'sys.mgw_tibrv_msg_t',
                   multiple_consumers => TRUE);
    dbms_aqadm.create_queue(queue_name =>'mgw_tibrv_src',
                            queue_table => 'mgw_tibrv_mc',
                            max_retries => 1000);
    dbms_aqadm.start_queue('mgw_tibrv_src');

    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_tibrv_sc',
                   queue_payload_type => 'sys.mgw_tibrv_msg_t',
                   multiple_consumers => FALSE);
    dbms_aqadm.create_queue(queue_name =>'mgw_tibrv_dest',
                            queue_table => 'mgw_tibrv_sc',
                            max_retries => 1000);
    dbms_aqadm.start_queue('mgw_tibrv_dest');
end;
/

